/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.actprof;

import com.ibm.hwmca.base.actprof.ActivationProfile;
import com.ibm.hwmca.base.actprof.ActivationProfileList;
import com.ibm.hwmca.base.actprof.ActivationProfileListBean;
import com.ibm.hwmca.base.actprof.ActivationProfileListConstants;
import com.ibm.hwmca.base.actprof.ActivationProfileListErrorIds;
import com.ibm.hwmca.base.actprof.ActivationProfileListTasklet;
import com.ibm.hwmca.base.actprof.ProfileReport;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.ResultsProcessor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActivationProfileUtil
implements ActivationProfileListErrorIds,
ActivationProfileListConstants {
    private static final String TRACE_MASKT = "XPROAPUT";
    private static final String TRACE_MASKF = "XPROAPUF";
    private static final String TRACE_MASKD = "XPROAPUD";
    private static final String RES_BUNDLE = "com.ibm.hwmca.base.actprof.res.ActivationProfileListRes";
    private static final String BUSY_TITLE = "WorkingBusy.Title";
    private static final String BUSY_MSG = "WorkingBusy.Msg";
    private Set impls;
    private Map implReports = new HashMap();

    public ActivationProfileListBean[] buildBeans(HwmcaObject[] targets, HwmcaPanelTasklet tasklet) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileUtil.buildBeans()");
        try {
            if (this.impls == null) {
                this.impls = this.getImpls(HwmcaObject.getIdsFromObjects(targets));
            }
            ArrayList<ActivationProfile> implData = new ArrayList<ActivationProfile>();
            ArrayList<ProfileReport> badData = new ArrayList<ProfileReport>();
            if (this.impls != null && this.impls.size() > 0) {
                Iterator iterator = this.impls.iterator();
                while (iterator.hasNext()) {
                    ActivationProfileList implClass = (ActivationProfileList)iterator.next();
                    ProfileReport[] reports = (ProfileReport[])this.implReports.get(implClass);
                    if (reports == null) {
                        reports = implClass.getProfiles(targets);
                        this.implReports.put(implClass, reports);
                    }
                    if (reports == null) continue;
                    for (int z = 0; z < reports.length; ++z) {
                        if (reports[z] == null || reports[z].getCompletionCode() == null) continue;
                        if (reports[z].getCompletionCode() == CompletionReportCode.SUCCESS) {
                            ActivationProfile[] profiles = reports[z].getProfiles();
                            for (int y = 0; y < profiles.length; ++y) {
                                profiles[y].setObjectId(reports[z].getObjectId());
                                implData.add(profiles[y]);
                            }
                            continue;
                        }
                        badData.add(reports[z]);
                    }
                }
            }
            Trace.trace(TRACE_MASKF, "   We have this many entries: " + implData.size());
            CompletionReport[] newSet = null;
            if (badData.size() > 0) {
                Trace.trace(TRACE_MASKF, "   Have some bad data.. informing the user");
                CompletionReport[] tmpArray = new CompletionReport[badData.size() + 1];
                for (int i = 0; i < badData.size(); ++i) {
                    tmpArray[i] = (CompletionReport)badData.get(i);
                }
                CompletionReport goodReport = new CompletionReport();
                goodReport.setCompletionCode(CompletionReportCode.SUCCESS);
                tmpArray[badData.size()] = goodReport;
                newSet = (CompletionReport[])tasklet.invokeExitOnClient(new ResultsProcessor(tmpArray, true));
                Trace.trace(TRACE_MASKF, "   Back from informing the user");
            }
            if (implData.size() == 0) {
                Trace.trace(TRACE_MASKF, "   No impl data");
                Trace.trace(TRACE_MASKF, "<- ActivationProfileUtil.buildBeans()");
                return null;
            }
            if (newSet != null && newSet.length == 0) {
                Trace.trace(TRACE_MASKF, "   New set length was 0");
                Trace.trace(TRACE_MASKF, "<- ActivationProfileUtil.buildBeans()");
                return null;
            }
            List sortedData = this.getSortedData(implData);
            implData = null;
            ActivationProfileListBean[] beans = new ActivationProfileListBean[sortedData.size()];
            for (int i = 0; i < beans.length; ++i) {
                beans[i] = new ActivationProfileListBean();
                List data = (List)sortedData.get(i);
                beans[i].setData(data);
                beans[i].setBeanName(((ActivationProfile)data.get(0)).getMachineName().toString());
                beans[i].setDisplayableBeanName(((ActivationProfile)data.get(0)).getMachineName());
                if (!(tasklet instanceof ActivationProfileListTasklet)) continue;
                Trace.trace(TRACE_MASKF, "setting viewOnly property");
                beans[i].setViewOnly(((ActivationProfileListTasklet)tasklet).isViewOnly());
            }
            Trace.trace(TRACE_MASKF, "   We have this many beans: " + beans.length);
            Trace.trace(TRACE_MASKF, "<- ActivationProfileUtil.buildBeans()");
            return beans;
        }
        catch (HException he) {
            new FrameworkLog(ActivationProfileListErrorIds._logInfo, -23295, he).log();
            Trace.trace(TRACE_MASKF, "<- ActivationProfileUtil.buildBeans()");
            throw new TaskletException(he);
        }
    }

    private List getSortedData(List unsortedData) {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileUtil.getSortedData()");
        ArrayList sortedData = new ArrayList();
        int i = 0;
        while (i < unsortedData.size()) {
            ArrayList<ActivationProfile> l = new ArrayList<ActivationProfile>();
            ActivationProfile prof = (ActivationProfile)unsortedData.get(0);
            String machine = prof.getMachineName().toString();
            l.add(prof);
            unsortedData.remove(0);
            int j = 0;
            while (j < unsortedData.size()) {
                prof = (ActivationProfile)unsortedData.get(j);
                if (prof.getMachineName().toString().equals(machine)) {
                    l.add(prof);
                    unsortedData.remove(j);
                    continue;
                }
                ++j;
            }
            sortedData.add(l);
        }
        Trace.trace(TRACE_MASKF, "<- ActivationProfileUtil.getSortedData()");
        return sortedData;
    }

    public void editProfile(ManagedObject mo, String profileName, HwmcaPanelTasklet tasklet, PanelTaskletResponse response, boolean viewOnly) throws HException {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileUtil.editProfile(ManagedObject, " + profileName + ",PanelTasklet,PanelTaskletResponse," + viewOnly + ")");
        ObjectId objId = mo.getObjectId();
        if (this.impls == null) {
            this.impls = this.getImpls(new ObjectId[]{objId});
        }
        if (this.impls == null || this.impls.size() != 1) {
            Trace.trace(TRACE_MASKF, "There were no impls to find.");
            this.showNoProfilesMsg(tasklet);
            throw new HException("Couldn't find impl");
        }
        ActivationProfileList impl = (ActivationProfileList)this.impls.iterator().next();
        ActivationProfile profile = impl.findProfile(new LocalizableText(profileName), mo);
        if (profile == null) {
            this.showNoProfilesMsg(tasklet);
            Trace.trace(TRACE_MASKF, "Could not find profile");
            throw new HException("Couldn't find profile");
        }
        this.editProfile(profile, tasklet, response, viewOnly);
        Trace.trace(TRACE_MASKF, "<- ActivationProfileUtil.editProfile(ManagedObject, " + profileName + ",PanelTasklet,PanelTaskletResponse," + viewOnly + ")");
    }

    public void editProfile(ActivationProfile profile, HwmcaPanelTasklet tasklet, PanelTaskletResponse response, boolean viewOnly) throws HException {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileUtil.editProfile(ActivationProfile,PanelTasklet,PanelTaskletResponse," + viewOnly + ")");
        ActivationProfileList impl = null;
        try {
            impl = this.findOwningImpl(profile, tasklet.getObjectsForIds(tasklet.getPresentationTaskParms().getTargetIds()));
        }
        catch (HException he) {
            throw new TaskletException(he);
        }
        ObjectId objId = profile.getObjectId();
        try {
            if (objId == null) {
                objId = this.findOwningTarget(profile, impl, tasklet.getObjectsForIds(tasklet.getPresentationTaskParms().getTargetIds()));
            }
        }
        catch (HException he) {
            throw new TaskletException(he);
        }
        if (impl != null && objId != null) {
            HashMap<String, Object> initData = new HashMap<String, Object>();
            initData.put("profile", profile);
            initData.put("objectId", objId);
            initData.put("viewOnly", new Boolean(viewOnly));
            initData.put("profileReportArray", this.findReports(profile, impl));
            DisplayAreaDescriptorDelegate delegate = new DisplayAreaDescriptorDelegate(impl.getProfileClientName(), initData);
            delegate.setMountPoint(null);
            DisplayAreaDescriptor[] descriptors = new DisplayAreaDescriptor[]{delegate};
            response.addPanelDescriptor(descriptors);
        } else {
            this.showNoProfilesMsg(tasklet);
            response.noAction();
        }
        Trace.trace(TRACE_MASKF, "<- ActivationProfileUtil.editProfile(ActivationProfile,PanelTasklet,PanelTaskletResponse," + viewOnly + ")");
    }

    public void deleteProfile(ActivationProfile profile, ActivationProfileList impl) throws HException {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileUtil.deleteProfile()");
        Trace.trace(TRACE_MASKF, "   profile = " + profile.getProfileName());
        boolean deleted = false;
        ProfileReport[] reports = (ProfileReport[])this.implReports.get(impl);
        for (int j = 0; j < reports.length && !deleted; ++j) {
            if (reports[j] == null) continue;
            Trace.trace(TRACE_MASKF, "   looking for profile = " + profile.getProfileName() + "in reports[" + j + "]");
            ActivationProfile[] profiles = reports[j].getProfiles();
            if (profiles == null) continue;
            for (int i = 0; i < profiles.length && !deleted; ++i) {
                int k;
                Trace.trace(TRACE_MASKF, "   comparing to profile[" + i + "] = " + profiles[i].getProfileName());
                if (!profiles[i].equals(profile)) continue;
                Trace.trace(TRACE_MASKF, "   profile match found, deleting...");
                ActivationProfile[] newProfiles = new ActivationProfile[profiles.length - 1];
                if (i != 0) {
                    for (k = 0; k < i; ++k) {
                        newProfiles[k] = profiles[k];
                    }
                }
                if (i != profiles.length - 1) {
                    for (k = i + 1; k < profiles.length; ++k) {
                        newProfiles[k - 1] = profiles[k];
                    }
                }
                reports[j].setProfiles(newProfiles);
                deleted = true;
                this.implReports.put(impl, reports);
            }
        }
        if (deleted) {
            Trace.trace(TRACE_MASKF, "   profile " + profile.getProfileName() + " was deleted");
        } else {
            Trace.trace(TRACE_MASKF, "   profile " + profile.getProfileName() + " was NOT deleted");
        }
        Trace.trace(TRACE_MASKF, "<- ActivationProfileUtil.deleteProfile()");
    }

    Set getImpls(ObjectId[] ids) throws HException {
        try {
            HashSet<ActivationProfileList> implSet = new HashSet<ActivationProfileList>();
            for (int i = 0; i < ids.length; ++i) {
                ActivationProfileList impl;
                ManagedObject mo = (ManagedObject)ManagedObjectManager.getManagedObjectManager().get(ids[i]);
                if (mo == null || (impl = (ActivationProfileList)mo.getInterfaceImpl(Class.forName("com.ibm.hwmca.base.actprof.ActivationProfileList"))) == null) continue;
                implSet.add(impl);
            }
            Trace.trace(TRACE_MASKD, "implSet size: " + implSet.size());
            return implSet;
        }
        catch (ClassNotFoundException cnfe) {
            new FrameworkLog(ActivationProfileListErrorIds._logInfo, -23295, cnfe).log();
            throw new HException(cnfe);
        }
    }

    ActivationProfileList findOwningImpl(ActivationProfile profile, HwmcaObject[] hObjs) throws HException {
        if (this.impls == null) {
            this.impls = this.getImpls(HwmcaObject.getIdsFromObjects(hObjs));
        }
        if (this.impls != null) {
            Iterator iterator = this.impls.iterator();
            while (iterator.hasNext()) {
                ActivationProfileList implClass = (ActivationProfileList)iterator.next();
                ProfileReport[] reports = (ProfileReport[])this.implReports.get(implClass);
                if (reports == null) {
                    reports = implClass.getProfiles(hObjs);
                    this.implReports.put(implClass, reports);
                }
                if (reports == null) continue;
                for (int j = 0; j < reports.length; ++j) {
                    ActivationProfile[] profiles;
                    if (reports[j] == null || (profiles = reports[j].getProfiles()) == null) continue;
                    for (int i = 0; i < profiles.length; ++i) {
                        if (!profiles[i].equals(profile)) continue;
                        return implClass;
                    }
                }
            }
        }
        return null;
    }

    ActivationProfile[] findReports(ActivationProfile profile, ActivationProfileList impl) {
        ProfileReport[] reports = (ProfileReport[])this.implReports.get(impl);
        if (reports != null) {
            for (int j = 0; j < reports.length; ++j) {
                ActivationProfile[] profiles;
                if (reports[j] == null || (profiles = reports[j].getProfiles()) == null) continue;
                for (int i = 0; i < profiles.length; ++i) {
                    if (!profiles[i].equals(profile)) continue;
                    return profiles;
                }
            }
        }
        return null;
    }

    ObjectId findOwningTarget(ActivationProfile profile, ActivationProfileList impl, HwmcaObject[] hObjs) throws HException {
        ProfileReport[] reports = (ProfileReport[])this.implReports.get(impl);
        if (reports == null) {
            reports = impl.getProfiles(hObjs);
            this.implReports.put(impl, reports);
        }
        if (reports != null) {
            for (int j = 0; j < reports.length; ++j) {
                ActivationProfile[] profiles;
                if (reports[j] == null || (profiles = reports[j].getProfiles()) == null) continue;
                for (int i = 0; i < profiles.length; ++i) {
                    if (profiles[i] == null || !profiles[i].equals(profile)) continue;
                    return reports[j].getObjectId();
                }
            }
        }
        return null;
    }

    public void showNoProfilesMsg(PanelTasklet tasklet) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileUtil.showNoProfileMsg()");
        LocalizableText title = null;
        title = new LocalizableText(RES_BUNDLE, "ActivationProfileListPanel.TEXT");
        MessageText[] bmt = new BaseMessageText[]{new BaseMessageText("xpro.noprofiles", null)};
        tasklet.showMessageBox(true, title, bmt, bmt[0].getMsgId(), bmt[0].getMsgType(), new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
        Trace.trace(TRACE_MASKF, "<- ActivationProfileUtil.showNoProfileMsg()");
    }
}

